@echo off
setlocal enabledelayedexpansion

set VENV_DIR=venv

echo ===============================================================
echo    CLIP Concept Viewer - Setup Script - by https://m14w.com/
echo ===============================================================
echo.

:: Detect CUDA version
set CUDA_VERSION=none
set CUDA_MAJOR=0

where nvcc >nul 2>&1
if %errorlevel% equ 0 (
    for /f "tokens=5 delims= " %%a in ('nvcc --version ^| findstr "release"') do (
        set CUDA_VERSION=%%a
    )
)

if "%CUDA_VERSION%"=="none" (
    where nvidia-smi >nul 2>&1
    if %errorlevel% equ 0 (
        for /f "tokens=9 delims= " %%a in ('nvidia-smi ^| findstr "CUDA Version"') do (
            set CUDA_VERSION=%%a
        )
    )
)

echo Detected CUDA version: %CUDA_VERSION%
echo.

:: Determine recommended PyTorch CUDA version
set PYTORCH_CUDA=cu121
set PYTORCH_CUDA_DESC=CUDA 12.1

if not "%CUDA_VERSION%"=="none" (
    for /f "tokens=1 delims=." %%a in ("%CUDA_VERSION%") do set CUDA_MAJOR=%%a
    for /f "tokens=2 delims=." %%a in ("%CUDA_VERSION%") do set CUDA_MINOR=%%a
    
    if !CUDA_MAJOR! geq 12 (
        if !CUDA_MINOR! geq 8 (
            set PYTORCH_CUDA=cu128
            set PYTORCH_CUDA_DESC=CUDA 12.8
        ) else if !CUDA_MINOR! geq 4 (
            set PYTORCH_CUDA=cu124
            set PYTORCH_CUDA_DESC=CUDA 12.4
        ) else (
            set PYTORCH_CUDA=cu121
            set PYTORCH_CUDA_DESC=CUDA 12.1
        )
    ) else if !CUDA_MAJOR! equ 11 (
        set PYTORCH_CUDA=cu118
        set PYTORCH_CUDA_DESC=CUDA 11.8
    )
)

echo Available PyTorch builds:
echo   1. %PYTORCH_CUDA_DESC% [Recommended based on detection]
echo   2. CUDA 12.8
echo   3. CUDA 12.4
echo   4. CUDA 12.1
echo   5. CUDA 11.8
echo   6. CPU only (no GPU acceleration)
echo.

set /p CHOICE="Select PyTorch version [1-6] (default=1): "
if "%CHOICE%"=="" set CHOICE=1

if "%CHOICE%"=="2" (
    set PYTORCH_CUDA=cu128
    set PYTORCH_CUDA_DESC=CUDA 12.8
) else if "%CHOICE%"=="3" (
    set PYTORCH_CUDA=cu124
    set PYTORCH_CUDA_DESC=CUDA 12.4
) else if "%CHOICE%"=="4" (
    set PYTORCH_CUDA=cu121
    set PYTORCH_CUDA_DESC=CUDA 12.1
) else if "%CHOICE%"=="5" (
    set PYTORCH_CUDA=cu118
    set PYTORCH_CUDA_DESC=CUDA 11.8
) else if "%CHOICE%"=="6" (
    set PYTORCH_CUDA=cpu
    set PYTORCH_CUDA_DESC=CPU only
)

echo.
echo Selected: %PYTORCH_CUDA_DESC%
echo.

if exist "%VENV_DIR%\Scripts\activate.bat" (
    echo Virtual environment already exists.
    set /p RECREATE="Recreate it? (y/N): "
    if /i "!RECREATE!"=="y" (
        echo Removing old venv...
        rmdir /s /q %VENV_DIR%
        goto :create_venv
    )
    goto :activate
)

:create_venv
echo Creating virtual environment...
python -m venv %VENV_DIR%
if errorlevel 1 (
    echo Failed to create virtual environment.
    echo Make sure Python is installed and in PATH.
    pause
    exit /b 1
)

:activate
echo Activating virtual environment...
call %VENV_DIR%\Scripts\activate.bat

echo Upgrading pip...
python -m pip install --upgrade pip

echo.
echo Installing PyTorch (%PYTORCH_CUDA_DESC%)...
if "%PYTORCH_CUDA%"=="cpu" (
    pip install torch torchvision --index-url https://download.pytorch.org/whl/cpu
) else (
    pip install torch torchvision --index-url https://download.pytorch.org/whl/%PYTORCH_CUDA%
)

echo.
echo Installing other dependencies...
pip install open-clip-torch transformers pillow psutil sentencepiece protobuf

echo.
echo ============================================
echo    Setup complete!
echo ============================================
echo.
echo To run the script:
echo   1. Run: activate.bat
echo   2. Run: python clip_picture_search_engine.py [options]
echo.
echo Options:
echo   --b32      Use lighter ViT-B/32 model
echo   --sigclip  Use SigLIP model
echo   --fast     Enable float16 + torch.compile
echo   --sub      Scan subdirectories
echo.
pause
